import viz
import vizmat

mouseTexture = viz.addTexture('mouse.png',filter=viz.NEAREST)

class ObjectGrabber(object):
	def __init__(self):
		viz.startlayer(viz.LINES)
		viz.vertexColor(viz.WHITE)
		viz.linewidth(2)
		viz.vertex(0,0,0)
		viz.vertex(0,0,0)
		self.__line = viz.endlayer()
		self.__line.visible(0)

		self.__mouse = viz.addTexQuad(viz.ORTHO)	
		self.__mouse.scale(64,64,1)
		self.__mouse.texture(mouseTexture)
		self.__mouse.draworder(99999)

		self.__spring = None
		
		self.pos = [0,0]
		self.bLine = [0,0,0]
		self.eLine = [0,0,0]

	def remove(self):
		self.__mouse.remove()
		self.__line.remove()
		
	def mouseVisible(self,visible):
		"""Set visibility of mouse"""
		self.__mouse.visible(visible)
		
	"""Client side commands"""
	def update(self,pos,lineBegin,lineEnd,grabbed):
		"""Update mouse and grab line from data"""
		self.__mouse.setPosition(pos[0],pos[1],0)
		self.__line.vertex(0,lineBegin)
		self.__line.vertex(1,lineEnd)
		self.__line.visible(grabbed)

	"""Server side commands"""
	def setMousePosition(self,pos,line):
		"""Set mouse position from pixel/normalized coordinates"""
		self.pos = pos
		self.__mouse.setPosition(pos[0],pos[1],0)
		if self.__spring:
			line.length = self.__dist
			self.__spring.setPosition(line.end)
			self.bLine = self.__obj.getMatrix().preMultVec(self.__offset)
			self.eLine = line.end
			self.__line.vertex(0,self.bLine)
			self.__line.vertex(1,self.eLine)
					
	def grab(self,obj,pos,begin):
		"""Grab the object with the given offset, and begin viewpoint"""
		self.__obj = obj
		self.__spring = obj.addSpring(viz.LINK_POS,linearKd=5,linearKs=140,offset=pos)
		
		#Save offset in local coordinates of object
		mat = obj.getMatrix()
		mat.invert()
		self.__offset = mat.preMultVec(pos)
		
		#Save distance of object from screen
		self.__dist = vizmat.Distance(begin,pos)
		
		#Make line visible
		self.__line.visible(1)
		
	def isGrabbing(self):
		"""Returns whether currently grabbing object"""
		return self.__spring is not None
		
	def release(self):
		"""Release any grabbed objects"""
		if self.__spring:
			self.__spring.remove()
			self.__spring = None
			self.__line.visible(0)
			
player = {}

def getGrabberNames():
	return player.keys()

def iterGrabbers():
	return player.iteritems()

def addGrabber(name):
	if name not in player:
		g = ObjectGrabber()
		if name.lower() == viz.getComputerName().lower():
			g.mouseVisible(0)
		player[name] = g
	
def removeGrabber(name):
	if name in player:
		player[name].remove()
		del player[name]
	
def getGrabber(name):
	return player.get(name,None)
	
def updateGrabbers():
	pass
